import { T } from "@tldraw/validate";
import { vecModelValidator } from "../misc/geometry-types.mjs";
import { createShapePropsMigrationIds, createShapePropsMigrationSequence } from "../records/TLShape.mjs";
import { DefaultColorStyle } from "../styles/TLColorStyle.mjs";
import { DefaultDashStyle } from "../styles/TLDashStyle.mjs";
import { DefaultFillStyle } from "../styles/TLFillStyle.mjs";
import { DefaultSizeStyle } from "../styles/TLSizeStyle.mjs";
const DrawShapeSegment = T.object({
  type: T.literalEnum("free", "straight"),
  points: T.arrayOf(vecModelValidator)
});
const drawShapeProps = {
  color: DefaultColorStyle,
  fill: DefaultFillStyle,
  dash: DefaultDashStyle,
  size: DefaultSizeStyle,
  segments: T.arrayOf(DrawShapeSegment),
  isComplete: T.boolean,
  isClosed: T.boolean,
  isPen: T.boolean,
  scale: T.nonZeroNumber
};
const Versions = createShapePropsMigrationIds("draw", {
  AddInPen: 1,
  AddScale: 2
});
const drawShapeMigrations = createShapePropsMigrationSequence({
  sequence: [
    {
      id: Versions.AddInPen,
      up: (props) => {
        const { points } = props.segments[0];
        if (points.length === 0) {
          props.isPen = false;
          return;
        }
        let isPen = !(points[0].z === 0 || points[0].z === 0.5);
        if (points[1]) {
          isPen = isPen && !(points[1].z === 0 || points[1].z === 0.5);
        }
        props.isPen = isPen;
      },
      down: "retired"
    },
    {
      id: Versions.AddScale,
      up: (props) => {
        props.scale = 1;
      },
      down: (props) => {
        delete props.scale;
      }
    }
  ]
});
export {
  DrawShapeSegment,
  drawShapeMigrations,
  drawShapeProps,
  Versions as drawShapeVersions
};
//# sourceMappingURL=TLDrawShape.mjs.map
